// webpack.config.js
const path = require('path');

module.exports = {
  // This tells webpack to produce code for a Node.js-like environment (which Electron's main process is)
  target: 'electron-main',
  // The entry point of our app
  entry: './main.js',
  // The output configuration
  output: {
    // The name of the bundled file
    filename: 'main.bundle.js',
    // The folder to put the bundled file in
    path: path.resolve(__dirname, 'build'),
  },
  // We don't need to bundle 'fs', 'path', or 'child_process' because they are built into Node.js/Electron
  externals: {
    fs: 'commonjs fs',
    path: 'commonjs path',
    child_process: 'commonjs child_process',
  },
  // Ensure that __dirname works as expected after bundling
  node: {
    __dirname: false,
  },
};