const { app } = require('electron');
const fs = require('fs');
const path = require('path');

class Store {
    constructor(opts) {
        const userDataPath = app.getPath('userData');
        this.path = path.join(userDataPath, opts.configName + '.json');
        this.data = this.parseDataFile(this.path, opts.defaults);
    }

    get() {
        return this.data;
    }

    set(key, value) {
        this.data[key] = value;
        try {
            fs.writeFileSync(this.path, JSON.stringify(this.data, null, 4));
        } catch (error) {
            console.error("Failed to write settings:", error);
        }
    }

    parseDataFile(filePath, defaults) {
        try {
            if (fs.existsSync(filePath) && fs.statSync(filePath).size > 0) {
                return JSON.parse(fs.readFileSync(filePath));
            }
            return defaults;
        } catch (error) {
            console.error(`Error parsing settings file at ${filePath}. Reverting to defaults.`, error);
            return defaults;
        }
    }
}

module.exports = Store;