const { contextBridge, ipcRenderer } = require('electron');

contextBridge.exposeInMainWorld('electronAPI', {
    send: (channel, data) => {
        const validChannels = [
            'show-context-menu', 'start-drag', 'drag', 'end-drag',
            'mouse-enter-widget', 'mouse-leave-widget',
            'set-new-location'
        ];
        if (validChannels.includes(channel)) {
            ipcRenderer.send(channel, data);
        }
    },
    on: (channel, func) => {
        const validChannels = [
            'set-style', 'load-settings', 'update-weather',
            'show-location-input'
        ];
        if (validChannels.includes(channel)) {
            ipcRenderer.on(channel, (event, ...args) => func(...args));
        }
    }
});